const { User, Wallet, Transaction } = require('../models');

// Obtener lista de referidos directos y estadísticas
exports.getMyReferrals = async (req, res) => {
  try {
    const userId = req.user.id;

    // Buscar hijos (referidos directos)
    const referrals = await User.findAll({
      where: { parentId: userId },
      attributes: ['id', 'username', 'email', 'createdAt'],
      include: [
        { 
          model: Wallet, 
          as: 'wallet',
          attributes: ['balance'] 
        }
      ]
    });

    // Calcular ganancias totales por referidos
    // Esto asume que tenemos transacciones tipo 'earning_referral' en la wallet del usuario
    const wallet = await Wallet.findOne({ where: { userId } });
    let totalEarnings = 0;
    
    if (wallet) {
      const earnings = await Transaction.findAll({
        where: {
          walletId: wallet.id,
          type: 'earning_referral',
          status: 'completed'
        }
      });
      
      totalEarnings = earnings.reduce((acc, curr) => acc + parseFloat(curr.amount), 0);
    }

    res.json({
      referrals,
      count: referrals.length,
      totalEarnings
    });

  } catch (error) {
    console.error(error);
    res.status(500).json({ message: 'Error al obtener referidos' });
  }
};
