const express = require('express');
const router = express.Router();
const { getTasks, completeTask, createTask, updateTask, deleteTask, getAdminTasks } = require('../controllers/taskController');
const { protect, admin } = require('../middleware/authMiddleware');

router.get('/', protect, getTasks);
router.post('/complete', protect, completeTask);

// Admin routes
router.get('/admin', protect, admin, getAdminTasks);
router.post('/', protect, admin, createTask);
router.put('/:id', protect, admin, updateTask);
router.delete('/:id', protect, admin, deleteTask);

module.exports = router;
