const express = require('express');
const router = express.Router();
const { getUsers, getUserById, updateUser, deleteUser, getAdminStats } = require('../controllers/userController');
const { protect, admin } = require('../middleware/authMiddleware');

router.use(protect);
router.use(admin);

router.get('/stats', getAdminStats); // Must be before /:id
router.get('/', getUsers);
router.get('/:id', getUserById);
router.put('/:id', updateUser);
router.delete('/:id', deleteUser);

module.exports = router;
